<?php
/**
 * Minerva.php
 *
 * @package Embera
 * @author Michael Pratt <yo@michael-pratt.com>
 * @link   http://www.michael-pratt.com/
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Embera\Provider;

use Embera\Url;

/**
 * Minerva Provider
 * Minerva is the easiest way to capture and share clickable instructions for anything on the inte...
 *
 * @link https://minervaknows.com/
 *
 */
class Minerva extends ProviderAdapter implements ProviderInterface
{
    /** inline {@inheritdoc} */
    protected $endpoint = 'https://oembed.minervaknows.com?format=json';

    /** inline {@inheritdoc} */
    protected static $hosts = [
        '*.minervaknows.com'
    ];

    /** inline {@inheritdoc} */
    protected $allowedParams = [ 'maxwidth', 'maxheight' ];

    /** inline {@inheritdoc} */
    protected $httpsSupport = true;

    /** inline {@inheritdoc} */
    protected $responsiveSupport = false;

    /** inline {@inheritdoc} */
    public function validateUrl(Url $url)
    {
        return (bool) (
            preg_match('~\.minervaknows\.com/(themes|featured-recipes|recipes)/([^/]+)~i', (string) $url) ||
            preg_match('~\.minervaknows\.com/(themes|recipes)/([^/]+)/(follow|recipes)~i', (string) $url)
        );
    }

    /** inline {@inheritdoc} */
    public function normalizeUrl(Url $url)
    {
        $url->convertToHttps();
        $url->removeQueryString();
        $url->removeLastSlash();

        return $url;
    }

}
