<?php

$redirect = null;
$system_message = '';

if (file_exists('upgrade_image/image.zip')) {
    if (!file_exists('upgrade_image/fns')) {
        $upgrade_image = 'upgrade_image/image.zip';
        $path = pathinfo(realpath($upgrade_image), PATHINFO_DIRNAME);

        $zip = new ZipArchive();
        $res = $zip->open($upgrade_image);

        if ($res === true) {
            if ($zip->extractTo($path)) {
                $zip->close();
                $redirect = 'update_files';
            } else {
                $system_message = 'Error: Unable to extract files from the image.';
            }
        } else {
            $system_message = 'Error: Unable to open image file. Error code: ' . $res;
        }
    } else {
        $redirect = 'update_files';
    }
} else {
    $system_message = 'Error: Image file is missing.';
}

if (!empty($redirect)) {
    $page_content = [
        'title' => 'Updating Grupo Files',
        'loading_text' => 'Updating Grupo Files',
        'subtitle' => 'Please Wait',
        'redirect' => 'index.php?process=update_files'
    ];
} else {
    $page_content = [
        'title' => 'Error',
        'page_content' => $system_message,
        'heading' => 'Oops',
        'page_status' => 'error',
        'button_text' => 'Reload Process',
        'button_link' => 'index.php?process=initial'
    ];
}
