var agora_video_client = null;
var isVideoChatActive = false;
video_chat_available = true;

var audio_only_chat = false;
var publish_local_media = true;
var preferredMicId;
var preferredCamId;
var currentCamId;
var currentMicId;
var mic_mute_on_load = false;

var videochat_GridContainer = document.getElementById('video-chat-grid');
var audiochat_GridContainer = document.getElementById('audio-chat-grid');
var agora_remoteStreams = {};
var video_chat_formData = new FormData();

var localTracks = {
    videoTrack: null,
    audioTrack: null
};
var previousTracks = {
    videoTrack: null,
    audioTrack: null
};
var remoteUsers = {};
var options = {
    appid: null,
    channel: null,
    uid: null,
    token: null
};

$("body").on("click", ".main .middle > .video_chat_interface > .video_chat_container .toggle_chat_window", function(e) {
    $('.main .middle > .video_chat_interface').toggleClass('show_chat_window');
});

$("body").on("click", ".main .middle > .video_chat_interface > .video_chat_container .leave_video_call", function(e) {
    if (isVideoChatActive) {
        exit_video_chat();
    }
});

$("body").on("click", ".main .chatbox .join_video_call", function(e) {

    if ($('.call_notification').length > 0) {
        if (!$('.call_notification .call_ringtone')[0].paused) {
            $('.call_notification .call_ringtone')[0].pause();
            $('.call_notification .call_ringtone')[0].currentTime = 0;
        }
    }

    video_chat_formData = new FormData();
    video_chat_formData.append('add', 'video_chat');

    if ($(".main .chatbox").attr('group_id') !== undefined) {
        video_chat_formData.append('group_id', $(".main .chatbox").attr('group_id'));
        current_video_chat_type = 'group';
        current_video_chat_id = $(".main .chatbox").attr('group_id');
    } else if ($(".main .chatbox").attr('user_id') !== undefined) {
        video_chat_formData.append('user_id', $(".main .chatbox").attr('user_id'));
        current_video_chat_type = 'private_chat';
        current_video_chat_id = $(".main .chatbox").attr('user_id');
    } else {
        console.log('Error : Failed to fetch conversation info');
        return;
    }

    if ($(this).attr('audio_only') !== undefined && $(this).attr('audio_only') === 'yes') {
        video_chat_formData.append('audio_only', true);
        audio_only_chat = true;
        $('.main .video_chat_container>.icons>span.toggle_video_call_camera').hide();
        $('.main .video_chat_container>.icons>span.toggle_screen_share').hide();
    } else {
        audio_only_chat = false;
        $('.main .video_chat_container>.icons>span.toggle_video_call_camera').show();
        $('.main .video_chat_container>.icons>span.toggle_screen_share').show();
    }

    if (user_csrf_token !== null) {
        video_chat_formData.append('csrf_token', user_csrf_token);
    }

    if (user_login_session_id !== null && user_access_code !== null && user_session_time_stamp !== null) {
        video_chat_formData.append('login_session_id', user_login_session_id);
        video_chat_formData.append('access_code', user_access_code);
        video_chat_formData.append('session_time_stamp', user_session_time_stamp);
    }

    $('.main .middle > .video_chat_interface > .video_chat_container > .video_chat_grid').html('');
    $('.video_chat_container > .video_chat_full_view').html('');
    $('.main .middle > .video_chat_interface').removeClass('d-none');
    $('.call_notification').addClass('d-none');

    if (audio_only_chat) {
        $('.main .middle > .video_chat_interface').addClass('audio_only_chat');
    } else {
        $('.main .middle > .video_chat_interface').removeClass('audio_only_chat');
    }


    if (isVideoChatActive) {
        console.log('Video Chat Already Active');
        exit_video_chat();
    } else {

        if ($('.main .chatbox').attr('user_id') !== undefined) {
            current_video_caller_id = $('.main .chatbox').attr('user_id');
        }

        initilazing_video_chat();
        create_video_chat();
    }
});

$("body").on('change', '.video_chat_settings_box .card .select_camera', async function(e) {
    const selectedCamId = $(this).val();

    try {
        await localTracks.videoTrack.setDevice(selectedCamId);
        currentCamId = selectedCamId;
        console.log("Camera switched to:", selectedCamId);
    } catch (error) {
        console.error("Failed to switch camera:", error);
    }
});

$("body").on('change', '.video_chat_settings_box .card .select_microphone', async function(e) {
    const selectedMicId = $(this).val();

    try {
        await localTracks.audioTrack.setDevice(selectedMicId);
        currentMicId = selectedMicId;
        console.log("Mic switched to:", selectedMicId);
    } catch (error) {
        console.error("Failed to switch Mic:", error);
    }
});

async function get_cam_list() {
    try {
        const devices = await navigator.mediaDevices.enumerateDevices();
        const videoDevices = devices.filter(device => device.kind === 'videoinput');

        const camSelect = document.querySelector('.video_chat_settings_box .card .select_camera');
        if (!camSelect) {
            console.warn("Camera select element not found.");
            return;
        }

        camSelect.innerHTML = '';

        if (videoDevices.length === 0) {
            console.warn("No video input devices found.");
            return;
        }

        let currentDeviceId = null;
        if (agora_video_client && preferredCamId) {
            currentDeviceId = preferredCamId;
        }

        $('.video_chat_settings_box .card .select_camera_box').show();

        videoDevices.forEach((device, index) => {
            const option = document.createElement('option');
            option.value = device.deviceId;
            option.textContent = device.label || `Camera ${index + 1}`;

            if (device.deviceId === currentDeviceId) {
                option.selected = true;
            }

            camSelect.appendChild(option);
        });

    } catch (error) {
        console.error("Error getting camera list:", error);
    }
}


async function get_mic_list() {
    try {
        const devices = await navigator.mediaDevices.enumerateDevices();
        const audioDevices = devices.filter(device => device.kind === 'audioinput');

        const micSelect = document.querySelector('.video_chat_settings_box .card select.select_microphone');
        micSelect.innerHTML = '';

        if (audioDevices.length === 0) {
            console.warn("No audio input devices found.");
            return;
        }

        let currentDeviceId = null;
        if (agora_video_client && preferredMicId) {
            currentDeviceId = preferredMicId;
        }

        audioDevices.forEach((device, index) => {
            const option = document.createElement("option");
            option.value = device.deviceId;
            option.textContent = device.label || `Microphone ${index + 1}`;

            if (device.deviceId === currentDeviceId) {
                option.selected = true;
            }

            micSelect.appendChild(option);
        });

    } catch (error) {
        console.error("Error getting microphone list:", error);
    }
}


$("body").on("click", ".main .middle > .video_chat_interface > .video_chat_container .toggle_video_call_mic", function(e) {

    if (!agora_video_client) {
        return;
    }

    if (!isVideoChatActive) {
        return;
    }

    if ($(this).find('.mic_muted').hasClass('d-none')) {

        if (localTracks.audioTrack) {
            localTracks.audioTrack.setMuted(true);
        }

        $(this).find('.mic_not_muted').addClass('d-none');
        $(this).find('.mic_muted').removeClass('d-none');

    } else {
        if (localTracks.audioTrack) {
            localTracks.audioTrack.setMuted(false);
        }
        $(this).find('.mic_muted').addClass('d-none');
        $(this).find('.mic_not_muted').removeClass('d-none');

    }

});


$("body").on("click", ".main .middle > .video_chat_interface > .video_chat_container .toggle_screen_share", function(e) {

    if (!agora_video_client) {
        return;
    }

    if (!isVideoChatActive) {
        return;
    }

    if ($(this).find('.share_user_screen').hasClass('d-none')) {
        stop_share_device_screen();
        $(this).find('.stop_screen_share').addClass('d-none');
        $(this).find('.share_user_screen').removeClass('d-none');
        $('.main .video_chat_container>.icons>span.toggle_video_call_camera').show();
    } else {
        share_device_screen();
        $(this).find('.share_user_screen').addClass('d-none');
        $(this).find('.stop_screen_share ').removeClass('d-none');
        $('.main .video_chat_container>.icons>span.toggle_video_call_camera').hide();
    }

});


$("body").on("click", ".main .middle > .video_chat_interface > .video_chat_container .toggle_video_call_camera", function(e) {

    if (!agora_video_client) {
        return;
    }

    if (!isVideoChatActive) {
        return;
    }

    if ($(this).find('.cam_disabled').hasClass('d-none')) {

        if (localTracks.videoTrack) {
            localTracks.videoTrack.setEnabled(false);
        }

        $(this).find('.cam_not_disabled').addClass('d-none');
        $(this).find('.cam_disabled').removeClass('d-none');
    } else {

        if (localTracks.videoTrack) {
            localTracks.videoTrack.setEnabled(true);
        }

        $(this).find('.cam_disabled').addClass('d-none');
        $(this).find('.cam_not_disabled').removeClass('d-none');
    }

});


agora_video_client = AgoraRTC.createClient({
    mode: "rtc", codec: "vp8"
});
agora_video_client.on("user-published", handleUserPublished);
agora_video_client.on("user-unpublished", handleUserUnpublished);
agora_video_client.on("user-left", handleUserLeft);

var create_video_chat = async () => {
    try {

        if (isVideoChatActive) {
            console.log('Video chat is already active. Leaving current session.');
            leaveChannel();
        }

        await joinChannel();
        console.log('AgoraRTC client initialized');
    } catch (error) {
        console.log(error);
    }
};

var exit_video_chat = async () => {

    $('.main .middle > .video_chat_interface').addClass('d-none');

    $('.toggle_video_call_mic .mic_muted').addClass('d-none');
    $('.toggle_video_call_mic .mic_not_muted').removeClass('d-none');

    $('.toggle_push_to_talk').removeClass('active');
    $('.toggle_push_to_talk').addClass('d-none');

    $('.toggle_screen_share .stop_screen_share').addClass('d-none');
    $('.toggle_screen_share .share_user_screen').removeClass('d-none');

    $('.toggle_video_call_camera .cam_disabled').addClass('d-none');
    $('.toggle_video_call_camera .cam_not_disabled').removeClass('d-none');

    total_vc_users = Object.keys(agora_video_client?.remoteUsers || {}).length;

    leaveChannel();
    stop_update_video_chat_status();
    current_video_chat_type = null;
    current_video_chat_id = null;
};

async function stop_share_device_screen() {

    try {

        if (localTracks.screenTrack) {
            await agora_video_client.unpublish(localTracks.screenTrack);
            localTracks.screenTrack.stop();
            localTracks.screenTrack.close();
            localTracks.screenTrack = null;
        }


        var localParticipantWindow = document.querySelector('.video-window.local-participant-window');

        if (localTracks.videoTrack) {
            localTracks.videoTrack.play(localParticipantWindow);
        }

        if (localTracks.audioTrack && !localTracks.videoTrack) {
            await agora_video_client.publish([localTracks.audioTrack]);
        } else if (localTracks.videoTrack) {
            await agora_video_client.publish([localTracks.videoTrack]);
        }

        if ($('.main .middle > .video_chat_interface > .video_chat_container').hasClass('full_view_container')) {
            if ($('.video_chat_container.full_view_container > .video_chat_full_view > div').length > 0) {
                $('.video_chat_container.full_view_container > .video_chat_full_view > div').appendTo('.main .middle > .video_chat_interface > .video_chat_container > .video_chat_grid');
            }

            $('.main .middle > .video_chat_interface > .video_chat_container').removeClass('full_view_container');
        }

    } catch (error) {
        console.error("Error stopping screenshare: " + error);
    }
}

async function share_device_screen() {
    try {
        var screenTrack = await AgoraRTC.createScreenVideoTrack({
            audio: 'auto',
        });

        if (isVideoChatActive) {

            if (localTracks.videoTrack) {
                await agora_video_client.unpublish(localTracks.videoTrack);
                localTracks.videoTrack.stop();
            }


            var localParticipantWindow = document.querySelector('.video-window.local-participant-window');

            localTracks.screenTrack = screenTrack;
            localTracks.screenTrack.play(localParticipantWindow);

            await agora_video_client.publish(localTracks.screenTrack);
        }

        if ($('.main .middle > .video_chat_interface > .video_chat_container').hasClass('full_view_container')) {
            if ($('.video_chat_container.full_view_container > .video_chat_full_view > div').length > 0) {
                $('.video_chat_container.full_view_container > .video_chat_full_view > div').appendTo('.main .middle > .video_chat_interface > .video_chat_container > .video_chat_grid');
            }

            $('.main .middle > .video_chat_interface > .video_chat_container').removeClass('full_view_container');
        }

        console.log("Screen sharing started");
    } catch (error) {
        console.error("Error sharing screen: " + error);
        $('.main .video_chat_container .toggle_screen_share .stop_screen_share').addClass('d-none');
        $('.main .video_chat_container .toggle_screen_share .share_user_screen').removeClass('d-none');
        $('.main .video_chat_container>.icons>span.toggle_video_call_camera').show();
    }
}

async function checkWebcamAndPermission() {
    try {
        var devices = await navigator.mediaDevices.enumerateDevices();
        var hasWebcam = devices.some(device => device.kind === 'videoinput');

        if (!hasWebcam) {
            return false;
        }

        try {
            var stream = await navigator.mediaDevices.getUserMedia({
                video: true
            });
            stream.getTracks().forEach(track => track.stop());
            return true;
        } catch (error) {
            return false;
        }
    } catch (error) {
        return false;
    }
}

async function checkMicrophonePermission() {
    try {
        var devices = await navigator.mediaDevices.enumerateDevices();
        var hasMicrophone = devices.some(device => device.kind === 'audioinput');

        if (!hasMicrophone) {
            return false;
        }

        try {
            var stream = await navigator.mediaDevices.getUserMedia({
                audio: true
            });

            stream.getTracks().forEach(track => track.stop());
            return true;
        } catch (error) {
            return false;
        }
    } catch (error) {
        return false;
    }
}

async function getPreferredMicrophone() {
    try {
        const devices = await navigator.mediaDevices.enumerateDevices();
        const audioDevices = devices.filter(device => device.kind === 'audioinput');

        if (audioDevices.length === 0) {
            console.warn("No audio input devices found.");
            return null;
        }

        if (currentMicId) {
            const match = audioDevices.find(device => device.deviceId === currentMicId);
            if (match) {
                console.log(`Using currentMicId: ${match.label}`);
                return currentMicId;
            }
        }

        const communicationsMic = audioDevices.find(device =>
            device.label.toLowerCase().includes("communications")
        );

        if (communicationsMic) {
            console.log(`Using communications microphone: ${communicationsMic.label}`);
            return communicationsMic.deviceId;
        }

        console.log(`Using fallback microphone: ${audioDevices[0].label}`);
        return audioDevices[0].deviceId;

    } catch (error) {
        console.error("Error getting audio input devices:", error);
        return null;
    }
}

async function getPreferredCamera() {
    try {
        const devices = await navigator.mediaDevices.enumerateDevices();
        const videoDevices = devices.filter(device => device.kind === 'videoinput');

        if (videoDevices.length === 0) {
            console.warn("No video input devices found.");
            return null;
        }

        if (currentCamId) {
            const match = videoDevices.find(device => device.deviceId === currentCamId);
            if (match) {
                console.log(`Using currentCamId: ${match.label}`);
                return currentCamId;
            }
        }

        const preferredCam = videoDevices.find(device =>
            device.label.toLowerCase().includes("front") ||
            device.label.toLowerCase().includes("default")
        );

        if (preferredCam) {
            console.log(`Using preferred camera: ${preferredCam.label}`);
            return preferredCam.deviceId;
        }

        console.log(`Using fallback camera: ${videoDevices[0].label}`);
        return videoDevices[0].deviceId;

    } catch (error) {
        console.error("Error getting video input devices:", error);
        return null;
    }
}

$(document).ready(function () {
    $('.toggle_push_to_talk').on('mousedown touchstart', function () {
        if (isVideoChatActive) {
            $(this).addClass('active');
            if (localTracks.audioTrack) {
                localTracks.audioTrack.setMuted(false);
            }
        }
    }).on('mouseup mouseleave touchend touchcancel', function () {
        if (isVideoChatActive) {
            $(this).removeClass('active');
            if (localTracks.audioTrack) {
                localTracks.audioTrack.setMuted(true);
            }
        }
    });
});

async function joinChannel() {

    var response = await fetch(api_request_url, {
        method: 'POST',
        body: video_chat_formData,
    });

    if (!response.ok) {
        throw new Error('Failed to fetch token from the server');
    }

    try {
        var data = await response.json();
    } catch (error) {
        console.error("Failed to parse server response as JSON:", error);
        exit_video_chat();
        return;
    }

    if (!data || typeof data !== 'object') {
        exit_video_chat();
        console.log('Invalid JSON data');
        return;
    } else if (data.alert_message !== undefined) {
        alert(data.alert_message);
        exit_video_chat();
        return;
    } else if (!data.channel) {
        exit_video_chat();
        console.log('Channel property is missing in JSON data');
        return;
    }

    if (audio_only_chat) {
        var cam_permissionGranted = false;
    } else {
        var cam_permissionGranted = await checkWebcamAndPermission();
    }

    var mic_permissionGranted = await checkMicrophonePermission();
    preferredMicId = await getPreferredMicrophone();


    if ($('.video-window.local-participant-window').length > 0) {
        return;
    }

    options = {
        appid: data.app_id,
        channel: data.channel,
        uid: null,
        token: data.token
    };

    publish_local_media = true;

    var videoTrack_create = null;
    var audioTrack_create = null;
    mic_mute_on_load = false;

    if (system_variable('push_to_talk_feature') === 'enable') {
        if ($(".main .chatbox").attr('group_id') !== undefined) {
            $('.toggle_push_to_talk').removeClass('active d-none');
            $('.main .video_chat_container>.icons>span.toggle_video_call_mic').hide();
            mic_mute_on_load = true;
        } else {
            $('.toggle_push_to_talk').addClass('d-none');
            $('.main .video_chat_container>.icons>span.toggle_video_call_mic').show();
        }
    }

    if (data.subscriber_only !== undefined) {
        publish_local_media = false;

        $('.main .video_chat_container>.icons>span.toggle_video_call_camera').hide();
        $('.main .video_chat_container>.icons>span.toggle_screen_share').hide();
        $('.main .video_chat_container>.icons>span.toggle_video_call_mic').hide();

    }

    if (publish_local_media) {
        audioTrack_create = mic_permissionGranted
        ? await AgoraRTC.createMicrophoneAudioTrack({
            encoderConfig: "high_quality_stereo",
            AEC: true,
            AGC: true,
            ANS: true,
            microphoneId: preferredMicId
        }): null;

        await get_mic_list();

        if (!audio_only_chat && cam_permissionGranted) {
            preferredCamId = await getPreferredCamera();

            videoTrack_create = await AgoraRTC.createCameraVideoTrack({
                cameraId: preferredCamId
            });

            await get_cam_list();
        } else {
            $('.video_chat_settings_box .card .select_camera_box').hide();
            videoTrack_create = null;
        }
    }


    [options.uid, localTracks.audioTrack, localTracks.videoTrack] = await Promise.all([
        agora_video_client.join(options.appid, options.channel, options.token || null, data.uid),
        audioTrack_create ? audioTrack_create: Promise.resolve(null),
        videoTrack_create ? videoTrack_create: Promise.resolve(null)
    ]);

    if (call_notification_timeout_id) {
        clearTimeout(call_notification_timeout_id);
    }

    $('.call_notification').attr('current_call_id', 0);

    isVideoChatActive = true;

    update_wsocket_data();

    if ($('.main .middle > .video_chat_interface').hasClass('d-none')) {
        exit_video_chat();
        return;
    }

    if (publish_local_media) {
        var localVideoContainer = document.getElementById('video-chat-grid');
        var localVideoElement = document.createElement('div');
        localVideoElement.className = 'video-window local-participant-window';

        var participantName = document.createElement('span');
        participantName.className = 'participant_name';
        participantName.textContent = 'You';

        localVideoElement.appendChild(participantName);

        localVideoContainer.appendChild(localVideoElement);

        $('.local-participant-window').find('.participant_name').addClass('get_info');
        $('.local-participant-window').find('.participant_name').attr('user_id', $('.logged_in_user_id').text());

        if ($(".main .chatbox").attr('group_id') !== undefined) {
            $('.local-participant-window').find('.participant_name').attr('data-group_identifier', $(".main .chatbox").attr('group_id'));
        }

        if (audio_only_chat) {
            $('.local-participant-window').append('<span class="participant_img"><img src="'+$('.logged_in_user_avatar').attr('src')+'"/></span>');
        }

        if (localTracks.videoTrack) {
            localTracks.videoTrack.play(localVideoElement);
        }

        if (localTracks.videoTrack && localTracks.audioTrack) {
            await agora_video_client.publish(Object.values(localTracks));
        } else if (localTracks.audioTrack) {
            await agora_video_client.publish([localTracks.audioTrack]);
        } else if (localTracks.videoTrack) {
            await agora_video_client.publish([localTracks.videoTrack]);
        }


        if (localTracks.audioTrack) {
            if (mic_mute_on_load) {

                if (system_variable('push_to_talk_feature') === 'enable') {
                    const pt_tooltipInstance = bootstrap.Tooltip.getInstance(document.getElementById('push_to_talk_icon'));
                    if (pt_tooltipInstance) {
                        pt_tooltipInstance.show();
                    }
                }
                localTracks.audioTrack.setMuted(true);
            } else {
                localTracks.audioTrack.setMuted(false);
            }
        }

        console.log("publish success");
        update_video_chat_status();
    }
}

async function leaveChannel() {
    if (!agora_video_client) {
        return;
    }

    if (!isVideoChatActive) {
        return;
    }

    for (trackName in localTracks) {
        var track = localTracks[trackName];
        if (track) {
            track.stop();
            track.close();
            localTracks[trackName] = undefined;
        }
    }

    remoteUsers = {};
    await agora_video_client.leave();

    var agoraVideoContainer = document.getElementById('video-chat-grid');
    agoraVideoContainer.innerHTML = '';

    $('.video_chat_container > .video_chat_full_view').html('');

    isVideoChatActive = false;

    console.log("client leaves channel success");
}

async function videoChat_channel_subscribe(user, mediaType) {
    var uid = user.uid;
    var unique_id_hash = uniqueCodeHash(uid);

    if (mediaType !== 'no_mediadata') {
        await agora_video_client.subscribe(user, mediaType);
    }

    if (mediaType === 'video' || mediaType === 'audio' || mediaType === 'no_mediadata') {
        var player_id = `player-${unique_id_hash}`;

        fetch_user_info(uid).then(function (userData) {
            var participantUsername = userData.username;

            var group_attribute = '';

            if ($(".main .chatbox").attr('group_id') !== undefined) {
                group_attribute = 'data-group_identifier="'+$(".main .chatbox").attr('group_id')+'"';
            }


            if (audio_only_chat) {
                var agora_player = $(`<div class="video-window player" id="${player_id}"><span class="participant_name">@${participantUsername}</span><span class="participant_img"><img src="${userData.image}"/></span></div>`);
            } else {
                var agora_player = $(`<div class="video-window player" id="${player_id}"><span ${group_attribute} class="participant_name get_info" user_id="${uid}">@${participantUsername}</span></div>`);
            }

            if (!$(`#${player_id}`).length) {
                $("#video-chat-grid").append(agora_player);
            }


            if (mediaType === 'video') {
                user.videoTrack.play(`player-${unique_id_hash}`);
            }

            if (mediaType === 'audio') {
                user.audioTrack.play();
            }


        }).catch(function (error) {
            console.log(error);
            var agora_player = $(`<div class="video-window player" id="${player_id}"><span class="participant_name">@${uid}</span></div>`);


            if (!$(`#${player_id}`).length) {
                $("#video-chat-grid").append(agora_player);
            }


            if (mediaType === 'video') {
                user.videoTrack.play(`player-${unique_id_hash}`);
            }

            if (mediaType === 'audio') {
                user.audioTrack.play();
            }
        });


    }
}

agora_video_client.enableAudioVolumeIndicator();

agora_video_client.on("volume-indicator", function (volumes) {
    $('.video_chat_grid > div').removeClass('talking');

    volumes.forEach(function (volume) {
        if (volume.level > 10) {
            const uid = volume.uid;
            const unique_id_hash = uniqueCodeHash(uid);

            if (current_logged_user_id && current_logged_user_id == uid) {
                $(`.video_chat_grid > div.local-participant-window`).addClass('talking');
            } else {
                $(`.video_chat_grid > #player-${unique_id_hash}`).addClass('talking');
            }
        }
    });
});

agora_video_client.on("user-joined", async (user) => {
    const uid = user.uid;
    const unique_id_hash = uniqueCodeHash(uid);
    const player_id = `player-${unique_id_hash}`;

    if (!$(`#${player_id}`).length) {
        videoChat_channel_subscribe(user, 'no_mediadata');
    }
});

function handleUserPublished(user, mediaType) {
    var id = user.uid;
    remoteUsers[id] = user;
    videoChat_channel_subscribe(user, mediaType);
}

function handleUserLeft(user, mediaType) {
    var id = user.uid;
    var unique_id_hash = uniqueCodeHash(id);

    if (mediaType === 'video' || mediaType === 'audio') {
        delete remoteUsers[id];
    }

    if ($(`#player-${unique_id_hash}`).parent().hasClass('video_chat_full_view')) {
        $('.main .middle > .video_chat_interface > .video_chat_container').removeClass('full_view_container');
    }

    $(`#player-${unique_id_hash}`).remove();

    var total_vclients = $('.main .middle > .video_chat_interface > .video_chat_container > .video_chat_grid > div').length;

    if (total_vclients === 0 && $('.main .middle > .video_chat_interface > .video_chat_container').hasClass('full_view_container')) {
        if ($('.video_chat_container.full_view_container > .video_chat_full_view > div').length > 0) {
            $('.video_chat_container.full_view_container > .video_chat_full_view > div').appendTo('.main .middle > .video_chat_interface > .video_chat_container > .video_chat_grid');
        }

        $('.main .middle > .video_chat_interface > .video_chat_container').removeClass('full_view_container');
    }
}

function handleUserUnpublished(user, mediaType) {
    if (mediaType === "audio") {
        console.log(`User ${user.uid} has muted their audio.`);
    } else if (mediaType === "video") {
        console.log(`User ${user.uid} has turned off their video.`);
    }
}